package com.esv.freight.customer.module.vehicle.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.freight.customer.module.vehicle.dto.VehicleDetailDto;
import com.esv.freight.customer.module.vehicle.entity.VehicleEntity;
import com.esv.freight.customer.module.vehicle.form.VehicleQueryForm;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 车辆表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-26 11:21:07
 */
@Mapper
public interface VehicleDao extends BaseMapper<VehicleEntity> {

    /**
     * description 查询车辆详情
     * param [id]
     * return com.esv.freight.customer.module.vehicle.dto.VehicleDetailDto
     * author Administrator
     * createTime 2020/04/27 14:02
     **/
    VehicleDetailDto selectVehicleDetail(Long id);

    /**
     * description 分页查询车辆列表
     * param [page, queryObj]
     * return com.baomidou.mybatisplus.core.metadata.IPage
     * author Administrator
     * createTime 2020/04/27 19:48
     **/
    IPage selectVehicle4Page(IPage page, VehicleQueryForm queryObj);

    /**
     * description 查询车辆列表
     * param [queryObj]
     * return java.util.List<com.esv.freight.customer.module.vehicle.dto.VehicleDetailDto>
     * author Administrator
     * createTime 2020/05/13 19:55
     **/
    List<VehicleDetailDto> selectVehicle4List(VehicleQueryForm queryObj);
	
}
