package com.esv.freight.customer.module.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.util.DateUtils;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.carrier.CarrierConstants;
import com.esv.freight.customer.module.carrier.entity.CarrierAccountEntity;
import com.esv.freight.customer.module.carrier.service.CarrierAccountService;
import com.esv.freight.customer.module.contract.dao.ContractOfflineCarrierDao;
import com.esv.freight.customer.module.contract.dto.ContractOfflineCarrierDto;
import com.esv.freight.customer.module.contract.entity.ContractOfflineCarrierEntity;
import com.esv.freight.customer.module.contract.form.ContractOfflineCarrierForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineCarrierQueryForm;
import com.esv.freight.customer.module.contract.service.ContractOfflineCarrierService;
import com.esv.freight.customer.module.contract.vo.ContractOfflineCarrierVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service("contractOfflineCarrierService")
public class ContractOfflineCarrierServiceImpl extends ServiceImpl<ContractOfflineCarrierDao, ContractOfflineCarrierEntity> implements ContractOfflineCarrierService {

    private ErrorMessageComponent errorMessageComponent;

    private CarrierAccountService carrierAccountService;

    @Autowired
    public ContractOfflineCarrierServiceImpl(ErrorMessageComponent errorMessageComponent, CarrierAccountService carrierAccountService) {
        this.errorMessageComponent = errorMessageComponent;
        this.carrierAccountService = carrierAccountService;
    }

    @Override
    public Long addOfflineContract(ContractOfflineCarrierForm form) {
        // 1:校验
        CarrierAccountEntity carrierAccountEntity = carrierAccountService.getCarrierById(form.getCarrierId());
        if (null == carrierAccountEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineCarrierAdd1001());
        }
        int count = this.baseMapper.selectCount(new LambdaQueryWrapper<ContractOfflineCarrierEntity>()
                .eq(ContractOfflineCarrierEntity::getCarrierId, form.getCarrierId())
                .eq(ContractOfflineCarrierEntity::getContractNumber, form.getContractNumber()));
        if (0 < count) {
            throw new EException(1002, errorMessageComponent.getContractOfflineCarrierAdd1002());
        }

        // 2:新增记录
        ContractOfflineCarrierEntity contractOfflineCarrierEntity = new ContractOfflineCarrierEntity();
        BeanUtils.copyProperties(form, contractOfflineCarrierEntity);
        contractOfflineCarrierEntity.setSignDate(DateUtils.parse(form.getSignDate(), DateUtils.DATE_FORMAT3));
        contractOfflineCarrierEntity.setStartDate(DateUtils.parse(form.getStartDate(), DateUtils.DATE_FORMAT3));
        contractOfflineCarrierEntity.setEndDate(DateUtils.parse(form.getEndDate(), DateUtils.DATE_FORMAT3));
        this.baseMapper.insert(contractOfflineCarrierEntity);

        return contractOfflineCarrierEntity.getId();
    }

    @Override
    public Integer editOfflineContract(ContractOfflineCarrierForm form) {
        // 1:校验
        ContractOfflineCarrierEntity dbEntity = this.baseMapper.selectById(form.getId());
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineCarrierEdit1001());
        }
        int count = this.baseMapper.selectCount(new LambdaQueryWrapper<ContractOfflineCarrierEntity>()
                .ne(ContractOfflineCarrierEntity::getId, form.getId())
                .eq(ContractOfflineCarrierEntity::getCarrierId, dbEntity.getCarrierId())
                .eq(ContractOfflineCarrierEntity::getContractNumber, form.getContractNumber()));
        if (0 < count) {
            throw new EException(1002, errorMessageComponent.getContractOfflineCarrierEdit1002());
        }

        // 2:更新记录
        ContractOfflineCarrierEntity contractOfflineCarrierEntity = new ContractOfflineCarrierEntity();
        BeanUtils.copyProperties(form, contractOfflineCarrierEntity);
        contractOfflineCarrierEntity.setCarrierId(null);
        contractOfflineCarrierEntity.setSignDate(DateUtils.parse(form.getSignDate(), DateUtils.DATE_FORMAT3));
        contractOfflineCarrierEntity.setStartDate(DateUtils.parse(form.getStartDate(), DateUtils.DATE_FORMAT3));
        contractOfflineCarrierEntity.setEndDate(DateUtils.parse(form.getEndDate(), DateUtils.DATE_FORMAT3));

        return this.baseMapper.updateById(contractOfflineCarrierEntity);
    }

    @Override
    public Integer deleteOfflineContract(ContractOfflineCarrierForm form) {
        ContractOfflineCarrierEntity dbEntity = this.baseMapper.selectById(form.getId());
        if (null == dbEntity) {
            throw new EException(1001, errorMessageComponent.getContractOfflineCarrierDelete1001());
        }

        return this.baseMapper.deleteById(form.getId());
    }

    @Override
    public PageResultVO selectContractList(ContractOfflineCarrierQueryForm queryForm) {
        IPage<ContractOfflineCarrierDto> page = new Page<>(queryForm.getPageNum(), queryForm.getPageSize());
        this.baseMapper.selectContractList(page, queryForm);

        // 数据转换
        List<ContractOfflineCarrierDto> dtoList = page.getRecords();
        List<ContractOfflineCarrierVO> targetRecordList = new ArrayList<>();
        for (ContractOfflineCarrierDto dto : dtoList) {
            ContractOfflineCarrierVO vo = new ContractOfflineCarrierVO();
            BeanUtils.copyProperties(dto, vo);
            if (CarrierConstants.CARRIER_TYPE_PERSONAL.equals(dto.getCarrierType())) {
                vo.setCarrierName(dto.getCarrierFullName());
            } else {
                vo.setCarrierName(dto.getContactor());
            }
            vo.setSignDate(dto.getSignDate().getTime());
            vo.setStartDate(dto.getStartDate().getTime());
            vo.setEndDate(dto.getEndDate().getTime());
            vo.setCreateTime(dto.getCreateTime().getTime());
            targetRecordList.add(vo);
        }

        return new PageResultVO(page, targetRecordList);
    }
}