package com.esv.freight.customer.module.goodsowner.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 货主信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
public class AccountAvailableVO implements Serializable {

	private static final long serialVersionUID = -5672242122935128064L;

	/**
	 * 
	 */
	private Long id;
	/**
	 * 登录帐号，货主手机号
	 */
	private String account;
	/**
	 * 客户编码
	 */
	private String ownerNumber;
	/**
	 * 货主名称（企业时为全称、个人时为联系人姓名）
	 */
	private String ownerName;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
