package com.esv.freight.customer.module.carrier.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 承运商信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-23 17:39:25
 */
@Data
@TableName("carrier_info")
public class CarrierInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 承运商帐号ID
	 */
	private Long accountId;
	/**
	 * 客户编码
	 */
	private String carrierNumber;
	/**
	 * 统一社会信用代码
	 */
	private String uniCreditCode;
	/**
	 * 承运商名称
	 */
	private String carrierFullName;
	/**
	 * 承运商简称
	 */
	private String carrierBriefName;
	/**
	 * 承运商类别：1-企业承运人、2-个体承运人
	 */
	private Integer carrierType;
	/**
	 * 承运商车辆类型（字典表）：1-自营车、2-外协车、3-其他
	 */
	private Integer carrierVehicleType;
	/**
	 * 企业注册地址-省份代码
	 */
	private String provinceCode;
	/**
	 * 企业注册地址-市代码
	 */
	private String cityCode;
	/**
	 * 企业注册地址-区县代码
	 */
	private String districtCode;
	/**
	 * 企业注册地址-详细地址
	 */
	private String detailAddress;
	/**
	 * 企业法人姓名
	 */
	private String legalPerson;
	/**
	 * 营业执照URL
	 */
	private String businessLicenseUrl;
	/**
	 * 道路运输经营许可证号
	 */
	private String roadLicenseNumber;
	/**
	 * 经营范围
	 */
	private String businessScope;
	/**
	 * 道路运输经营许可证有效期
	 */
	private String roadLicenseExpireDate;
	/**
	 * 道路运输经营许可证URL
	 */
	private String roadLicenseUrl;
	/**
	 * 联系人
	 */
	private String contactor;
	/**
	 * 电子邮件
	 */
	private String email;
	/**
	 * 信用评分：1-100
	 */
	private Integer creditScore;
	/**
	 * 上报状态
	 */
	private Integer reportState;
	/**
	 * 上报时间
	 */
	private Date reportTime;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
