package com.esv.freight.customer.module.driver.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.driver.form.DriverQueryForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.controller.DriverTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/28 20:27
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class DriverTest extends BaseTestController {

    /**
     * 查询司机详情
     **/
    @Test
    public void a1_detail_success_test() throws Exception {
        String url = "/carrier/driver/detail";

        // 构造数据
        DriverQueryForm form = new DriverQueryForm();
        form.setId(2L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(null != result.getJSONObject("data"));
    }

    /**
     * 查询司机详情：无效的账号ID
     **/
    @Test
    public void a2_detail_wrong_id_failure_test() throws Exception {
        String url = "/carrier/driver/detail";

        // 构造数据
        DriverQueryForm form = new DriverQueryForm();
        form.setId(99999L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }
}
