package com.esv.freight.customer.module.driver.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.module.driver.dto.DriverDetailDto;
import com.esv.freight.customer.module.driver.entity.DriverAccountEntity;
import com.esv.freight.customer.module.driver.form.DriverInfoForm;

/**
 * 司机帐号表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 14:47:01
 */
public interface DriverAccountService extends IService<DriverAccountEntity> {

    /**
     * description 新增司机
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/28 16:48
     **/
    Long insertDriver(DriverInfoForm form);

    /**
     * description 更新司机信息
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/28 19:13
     **/
    Integer updateDriver(DriverInfoForm form);

    /**
     * description 查询司机详情
     * param [id]
     * return com.esv.freight.customer.module.driver.dto.DriverDetailDto
     * author Administrator
     * createTime 2020/04/28 20:22
     **/
    DriverDetailDto getDriverDetail(Long id);

}

