package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.AccountAndAddressForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class AccountAndAddressForm {

    @NotNull(message = "参数ownerId不能为空", groups = {ValidatorDetail.class})
    private Long ownerId;

    @NotNull(message = "参数deliveryAddressId不能为空", groups = {ValidatorDetail.class})
    private Long deliveryAddressId;

    @NotNull(message = "参数receiveAddressId不能为空", groups = {ValidatorDetail.class})
    private Long receiveAddressId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
