package com.esv.freight.customer.common.util;

import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.util.VerifyUtilsTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/18 11:23
 * @version:1.0
 */
@SpringBootTest
@Slf4j
public class VerifyUtilsTest {

    @Test
    public void isValidIdCard18_test() {
        String idCard = "360721198712030856";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));

        idCard = "11010119900307045X";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));

        idCard = "110101199003075031";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));

        idCard = "110101199003073095";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));

        idCard = "110101199003079219";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));

        idCard = "110101199003075357";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));

        idCard = "36072119871203085x";
        log.info("{}={}", idCard, VerifyUtils.isValidIdCard18(idCard));
    }
}
