package com.esv.freight.customer.common.component;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.feign.FeignBaseService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @description: 基础数据组件
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.component.BaseDataComponent
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/08 15:57
 * @version:1.0
 */
@Component
@Slf4j
public class BaseDataComponent {

    @Value("${spring.application.name}")
    private String applicationName;

    private FeignBaseService feignBaseService;

    private RedisComponent redisComponent;

    private static final String ALL_REGION_MAP_CACHE_KEY = "::base-data::city::allMap";
    private static final Long ALL_REGION_MAP_CACHE_TIME = 36000L;

    @Autowired
    public BaseDataComponent(FeignBaseService feignBaseService, RedisComponent redisComponent) {
        this.feignBaseService = feignBaseService;
        this.redisComponent = redisComponent;
    }

    /**
     * description 获取全国省市行政区划(键值对)
     * param []
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/08 16:10
     **/
    public JSONObject getAllRegionMap() {
        JSONObject allRegionMap = new JSONObject();
        if (redisComponent.hasKey(this.getAllRegionMapCacheKey())) {
            allRegionMap = JSONObject.parseObject((String) redisComponent.get(this.getAllRegionMapCacheKey()));
        } else {
            try {
                JSONObject feignResultJson = feignBaseService.getAllRegionMap(new JSONObject());
                if (ECode.SUCCESS.code() == feignResultJson.getIntValue("code")) {
                    allRegionMap = feignResultJson.getJSONObject("data");
                    redisComponent.set(this.getAllRegionMapCacheKey(), allRegionMap.toJSONString(), ALL_REGION_MAP_CACHE_TIME);
                }
            } catch (Exception e) {
                log.error("调用[基础服务]获取全国省市行政区划(键值对)失败：{}", e.getMessage(), e);
            }
        }

        return allRegionMap;
    }

    public String getAllRegionMapCacheKey() {
        return applicationName + ALL_REGION_MAP_CACHE_KEY;
    }

}
