package com.esv.freight.customer.common.component;

import com.esv.freight.customer.common.unionpay.SDKConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.component.ApplicationLoadRunner
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 14:57
 * @version:1.0
 */
@Slf4j
@Component
public class ApplicationLoadRunner implements ApplicationRunner {

    @Value("${spring.application.name}")
    private String applicationName;

    @Value("${spring.profiles.active}")
    private String profilesActive;

    @Value("${unionpay.acp-sdk.properties.path}")
    private String acpSdkPropertiesPath;

    @Override
    public void run(ApplicationArguments var) {
        log.info("-------------------- [{}]初始化完成 --------------------", applicationName);

        // 初始化银联配置文件
        initUnionpayProperties();
    }

    /**
     * 初始化银联配置文件
     **/
    private void initUnionpayProperties() {
        if ("dev".equals(profilesActive)) {
            SDKConfig.getConfig().loadPropertiesFromSrc();
        } else {
            SDKConfig.getConfig().loadPropertiesFromPath(acpSdkPropertiesPath);
        }
    }
}
