package com.esv.freight.customer.module.contract.dto;

import lombok.Data;

import java.util.Date;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.dto.ContractOfflineCarrierDto
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/20 15:21
 * @version:1.0
 */
@Data
public class ContractOfflineCarrierDto {

    /**
     *
     */
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 承运商帐号ID
     */
    private Long carrierId;
    /**
     * 合同编号
     */
    private String contractNumber;
    /**
     * 合同名称
     */
    private String contractName;
    /**
     * 合同类型：1-主合同、2-补充合同、3-临时合同
     */
    private Integer contractType;
    /**
     * 合同签订日期
     */
    private Date signDate;
    /**
     * 合同起始日期
     */
    private Date startDate;
    /**
     * 合同截止日期
     */
    private Date endDate;
    /**
     * 合同文件URL
     */
    private String fileUrl;
    /**
     * 删除标识：0-未删除，1-已删除
     */
    private Boolean deleted;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 修改者
     */
    private String updateUser;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 承运商名称
     */
    private String carrierFullName;
    /**
     * 承运商类别：1-企业承运人、2-个体承运人
     */
    private Integer carrierType;
    /**
     * 联系人
     */
    private String contactor;
}
