package com.esv.freight.customer.module.vehicle.form;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.vehicle.form.VehicleAuditForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/26 14:35
 * @version:1.0
 */
@Data
public class VehicleAuditForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空")
    private Long id;
    /**
     * 审核状态(字典表)：1-审核成功，2-审核失败
     */
    @Range(min = 1, max = 2, message = "参数auditState不合法")
    @NotNull(message = "参数auditState不能为空")
    private Integer auditState;

    /**
     * 备注，审核不通过时必填
     */
    @Length(max = 100, message = "参数remark长度不合法")
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
