package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.*;
import com.esv.freight.customer.module.goodsowner.GoodsOwnerConstants;
import com.esv.freight.customer.module.goodsowner.form.DeleteAddressForm;
import com.esv.freight.customer.module.goodsowner.form.ReceiveAddressForm;
import com.esv.freight.customer.module.goodsowner.service.DeliveryAddressService;
import com.esv.freight.customer.module.goodsowner.service.ReceiveAddressService;
import com.esv.freight.customer.module.goodsowner.validator.groups.AddressBrief;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 承运商收货地址Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.ReceiveAddressController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/21 15:40
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/goodsowner/receive/address")
@Validated
public class ReceiveAddressController {

    private DeliveryAddressService deliveryAddressService;

    private ReceiveAddressService receiveAddressService;

    @Autowired
    public ReceiveAddressController(DeliveryAddressService deliveryAddressService, ReceiveAddressService receiveAddressService) {
        this.deliveryAddressService = deliveryAddressService;
        this.receiveAddressService = receiveAddressService;
    }

    /**
     * description 新增收货地址
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 16:56
     **/
    @PostMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) ReceiveAddressForm form) throws EException {
        // 判断是否复制地址
        if (GoodsOwnerConstants.ADDRESS_COPY_YES.equals(form.getAddressCopy())) {

        }

        Long id = receiveAddressService.addAddress(form);
        JSONObject data = new JSONObject();
        data.put("id", id);
        return EResponse.ok(data);
    }

    /**
     * description 编辑收货地址
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 18:56
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody @Validated(ValidatorUpdate.class) ReceiveAddressForm form) throws EException {
        receiveAddressService.editAddress(form);
        return EResponse.ok();
    }

    /**
     * description 查看收货地址详情
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 19:55
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestBody @Validated(ValidatorDetail.class) ReceiveAddressForm form) throws EException {
        return EResponse.ok(receiveAddressService.getAddressDetail(form));
    }

    /**
     * description 获取所有收货地址列表
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 20:08
     **/
    @PostMapping("/all")
    public EResponse all(@RequestBody @Validated(AddressBrief.class) ReceiveAddressForm form) throws EException {
        return EResponse.ok(receiveAddressService.getAllAddress(form));
    }

    /**
     * description 删除收货地址
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 19:27
     **/
    @PostMapping("/delete")
    public EResponse delete(@RequestBody @Validated(ValidatorDelete.class) DeleteAddressForm form) throws EException {
        int count = receiveAddressService.deleteAddress(form);
        JSONObject data = new JSONObject();
        data.put("count", count);
        return EResponse.ok(data);
    }

    /**
     * description 分页查询收货地址列表
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 9:28
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody @Validated(ValidatorList.class) ReceiveAddressForm form) throws EException {
        return EResponse.ok(receiveAddressService.selectAddressList(form));
    }
}
