package com.esv.freight.customer.module.contract.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.vo.ContractOfflineCarrierDetailVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/19 14:24
 * @version:1.0
 */
@Data
public class ContractOfflineCarrierDetailVO {
    /**
     *
     */
    private Long id;
    /**
     * 承运商ID
     */
    private Long carrierId;
    /**
     * 合同编号
     */
    private String contractNumber;
    /**
     * 合同名称
     */
    private String contractName;
    /**
     * 合同类型：1-主合同、2-补充合同、3-临时合同
     */
    private Integer contractType;
    /**
     * 合同签订日期
     */
    private String signDate;
    /**
     * 合同起始日期
     */
    private String startDate;
    /**
     * 合同截止日期
     */
    private String endDate;
    /**
     * 合同文件URL
     */
    private String fileUrl;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 客户名称
     */
    private String carrierName;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
