package com.esv.freight.customer.module.driver.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 司机信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 14:47:01
 */
@Data
@TableName("driver_info")
public class DriverInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 承运商帐号ID
	 */
	private Long carrierId;
	/**
	 * 司机帐号ID
	 */
	private Long driverId;
	/**
	 * 姓名
	 */
	private String name;
	/**
	 * 身份证号码
	 */
	private String idCard;
	/**
	 * 身份证有效期
	 */
	private String idCardExpireDate;
	/**
	 * 身份证正面图片URL
	 */
	private String idCardFrontUrl;
	/**
	 * 身份证背面图片URL
	 */
	private String idCardBackUrl;
	/**
	 * 结算对象(字典表)：1-个人、2-所属承运商
	 */
	private Integer settlementType;
	/**
	 * 性别(字典表)：1-男、2-女、3-未知
	 */
	private Integer sex;
	/**
	 * 出生日期
	 */
	private String birthDate;
	/**
	 * 名族
	 */
	private String nation;
	/**
	 * 籍贯
	 */
	private String nativePlace;
	/**
	 * 住址-省份代码
	 */
	private String provinceCode;
	/**
	 * 住址-市代码
	 */
	private String cityCode;
	/**
	 * 住址-区县代码
	 */
	private String districtCode;
	/**
	 * 住址-详细地址
	 */
	private String detailAddress;
	/**
	 * 驾驶证号码
	 */
	private String drivingLicense;
	/**
	 * 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
	 */
	private Integer drivingLicenseType;
	/**
	 * 驾驶证有效期起
	 */
	private String drivingLicenseStartDate;
	/**
	 * 驾驶证有效期止
	 */
	private String drivingLicenseEndDate;
	/**
	 * 发证机关
	 */
	private String drivingLicenseIssueDepartment;
	/**
	 * 初次获得驾驶证日期
	 */
	private String drivingLicenseInitDate;
	/**
	 * 驾驶证正面图片URL
	 */
	private String drivingLicenseUrl;
	/**
	 * 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
	 */
	private Integer certificateVehicle;
	/**
	 * 道路运输从业资格证-有效期止
	 */
	private String certificateEndDate;
	/**
	 * 道路运输从业资格证-从业资格证号
	 */
	private String certificateNumber;
	/**
	 * 道路运输从业资格证-正面图片URL
	 */
	private String certificateUrl;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 综合评分
	 */
	private Integer overallScore;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
