package com.esv.freight.customer.module.contract.form;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.form.ContractOnlineRecordSignDriverForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/21 17:44
 * @version:1.0
 */
@Data
public class ContractOnlineRecordSignDriverForm {

    /**
     * 司机ID
     */
    @NotNull(message = "参数driverId不能为空")
    private Long driverId;
    /**
     * 业务编号（订单号或运单号）
     */
    @Length(max = 50, message = "参数businessNumber长度不合法")
    @NotBlank(message = "参数businessNumber不能为空")
    private String businessNumber;
    /**
     * 货物名称
     */
    @Length(max = 50, message = "参数goodsName长度不合法")
    @NotBlank(message = "参数goodsName不能为空")
    private String goodsName;
    /**
     * 货物总量
     */
    @Length(max = 50, message = "参数goodsTotal长度不合法")
    @NotBlank(message = "参数goodsTotal不能为空")
    private String goodsTotal;
    /**
     * 货物单位
     */
    @Length(max = 50, message = "参数goodsUnit长度不合法")
    @NotBlank(message = "参数goodsUnit不能为空")
    private String goodsUnit;
    /**
     * 货物单价
     */
    @Length(max = 50, message = "参数goodsUnitPrice长度不合法")
    @NotBlank(message = "参数goodsUnitPrice不能为空")
    private String goodsUnitPrice;
    /**
     * 货物总价
     */
    @Length(max = 50, message = "参数goodsTotalPrice长度不合法")
    @NotBlank(message = "参数goodsTotalPrice不能为空")
    private String goodsTotalPrice;
    /**
     * 发货地址
     */
    @Length(max = 200, message = "参数deliverAddress长度不合法")
    @NotBlank(message = "参数deliverAddress不能为空")
    private String deliverAddress;
    /**
     * 收货地址
     */
    @Length(max = 200, message = "参数receiveAddress长度不合法")
    @NotBlank(message = "参数receiveAddress不能为空")
    private String receiveAddress;
    /**
     * 发货时间
     */
    @Length(max = 50, message = "参数deliverTime长度不合法")
    @NotBlank(message = "参数deliverTime不能为空")
    private String deliverTime;
    /**
     * 交货时间
     */
    @Length(max = 50, message = "参数receiveTime长度不合法")
    @NotBlank(message = "参数receiveTime不能为空")
    private String receiveTime;
    /**
     * 运费
     */
    @Length(max = 50, message = "参数freightCharge长度不合法")
    @NotBlank(message = "参数freightCharge不能为空")
    private String freightCharge;
    /**
     * 货主签名数据，base64编码
     */
    @NotBlank(message = "参数signData不能为空")
    private String signData;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
