package com.esv.freight.customer.module.carrier.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.freight.customer.module.carrier.dto.CarrierInfoDto;
import com.esv.freight.customer.module.carrier.entity.CarrierAccountEntity;
import com.esv.freight.customer.module.carrier.form.CarrierQueryForm;
import com.esv.freight.customer.module.goodsowner.form.AccountQueryForm;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 承运商帐号表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-23 16:51:54
 */
@Mapper
public interface CarrierAccountDao extends BaseMapper<CarrierAccountEntity> {

    /**
     * description 查询帐号列表
     * param [queryObj]
     * return java.util.List<com.esv.freight.customer.module.carrier.dto.CarrierInfoDto>
     * author Administrator
     * createTime 2020/04/23 19:36
     **/
    List<CarrierInfoDto> selectCarrierList(CarrierQueryForm queryObj);

    /**
     * description 分页查询帐号列表
     * param [page, queryObj]
     * return com.baomidou.mybatisplus.core.metadata.IPage
     * author Administrator
     * createTime 2020/04/26 9:27
     **/
    IPage selectCarrier4Page(IPage page, CarrierQueryForm queryObj);

    /**
     * description 查询承运商详情
     * param [queryObj]
     * return com.esv.freight.customer.module.carrier.dto.CarrierInfoDto
     * author Administrator
     * createTime 2020/04/24 17:06
     **/
    CarrierInfoDto selectCarrierDetail(CarrierQueryForm queryObj);

    /**
     * description 查询所有帐号简要信息
     * param []
     * return java.util.List<com.esv.freight.customer.module.carrier.dto.CarrierInfoDto>
     * author Administrator
     * createTime 2020/04/24 17:36
     **/
    List<CarrierInfoDto> selectAllCarrierBrief();

}
