package com.esv.freight.customer.module.pay.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 货主支付订单表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-30 13:41:51
 */
@Data
@TableName("goods_owner_pay_order")
public class GoodsOwnerPayOrderEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 支付方式：10-银联
	 */
	private Integer payType;
	/**
	 * 商户代码(网络货运平台在支付平台的商户号)
	 */
	private String merId;
	/**
	 * 业务订单号
	 */
	private String orderId;
	/**
	 * 请求支付平台订单发送时间
	 */
	private String txnTime;
	/**
	 * 交易金额(单位为分)
	 */
	private Long txnAmt;
	/**
	 * 订单描述
	 */
	private String orderDesc;
	/**
	 * 支付平台受理订单号
	 */
	private String tn;
	/**
	 * 订单状态：1-支付中、2-支付成功、3-支付失败
	 */
	private Long orderStatus;
	/**
	 * 查询流水号(消费交易的流水号，供后续查询用)
	 */
	private String queryId;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;
	/**
	 * 支付平台回调时间
	 */
	private Date callbackTime;

}
