package com.esv.freight.customer.module.contract.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.contract.entity.ContractOfflineGoodsOwnerEntity;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerQueryForm;
import com.esv.freight.customer.module.goodsowner.form.AccountQueryForm;

/**
 * 线下文本合同（货主）
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-19 14:05:38
 */
public interface ContractOfflineGoodsOwnerService extends IService<ContractOfflineGoodsOwnerEntity> {

    /**
     * description 新增线下文本合同（货主）
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/19 14:49
     **/
    Long addOfflineContract(ContractOfflineGoodsOwnerForm form);

    /**
     * description 编辑线下文本合同（货主）
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/19 19:34
     **/
    Integer editOfflineContract(ContractOfflineGoodsOwnerForm form);

    /**
     * description 删除线下文本合同（货主）
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/20 9:24
     **/
    Integer deleteOfflineContract(ContractOfflineGoodsOwnerForm form);

    /**
     * description 分页查询合同列表
     * param [queryForm]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/05/20 11:18
     **/
    PageResultVO selectContractList(ContractOfflineGoodsOwnerQueryForm queryForm);

}

