package com.esv.freight.customer.module.contract.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 线上电子合同记录表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-05-21 15:55:34
 */
@Data
@TableName("contract_online_record")
public class ContractOnlineRecordEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 合同类型：1-货主与平台合同、2-司机与平台合同
	 */
	private Integer contractType;
	/**
	 * 合同文件ID
	 */
	private String contractFileId;
	/**
	 * 合同文件URL
	 */
	private String contractFileUrl;
	/**
	 * 合同编号
	 */
	private String contractNumber;
	/**
	 * 业务编号（订单号或运单号）
	 */
	private String businessNumber;
	/**
	 * 客户（货主或司机）签订时间
	 */
	private Date customerSignTime;
	/**
	 * 平台签订时间
	 */
	private Date platformSignTime;
	/**
	 * 合同签订完成：1-是，2-否
	 */
	private Integer signComplete;
	/**
	 * 合同生效时间
	 */
	private Date effectiveTime;

}
