package com.esv.freight.customer.module.contract.controller;

import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.module.contract.form.ContractOnlineRecordSignGoodsOwnerForm;
import com.esv.freight.customer.module.contract.service.ContractOnlineRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOnlineRecordController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 11:08
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/contract/online")
@Validated
public class ContractOnlineRecordController {
    
    private ContractOnlineRecordService contractOnlineRecordService;

    @Autowired
    public ContractOnlineRecordController(ContractOnlineRecordService contractOnlineRecordService) {
        this.contractOnlineRecordService = contractOnlineRecordService;
    }

    /**
     * description 货主与平台的电子合同-货主签订
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/05/22 11:10
     **/
    @PostMapping("/goodsowner/sign")
    public EResponse goodsOwnerSign(@RequestBody @Validated ContractOnlineRecordSignGoodsOwnerForm form) throws EException {
        return EResponse.ok(contractOnlineRecordService.goodsOwnerSign(form));
    }
}
