package com.esv.freight.customer.module.driver.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.driver.dto.DriverDetailDto;
import com.esv.freight.customer.module.driver.entity.DriverAccountEntity;
import com.esv.freight.customer.module.driver.entity.DriverAuditHistoryEntity;
import com.esv.freight.customer.module.driver.form.DriverAuditForm;
import com.esv.freight.customer.module.driver.form.DriverInfoForm;
import com.esv.freight.customer.module.driver.form.DriverQueryForm;

import java.util.List;

/**
 * 司机帐号表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 14:47:01
 */
public interface DriverAccountService extends IService<DriverAccountEntity> {

    /**
     * description 新增司机
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/28 16:48
     **/
    Long insertDriver(DriverInfoForm form);

    /**
     * description 更新司机信息
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/28 19:13
     **/
    Integer updateDriver(DriverInfoForm form);

    /**
     * description 查询司机详情-通过ID
     * param [id]
     * return com.esv.freight.customer.module.driver.dto.DriverDetailDto
     * author Administrator
     * createTime 2020/04/28 20:22
     **/
    DriverDetailDto getDriverDetailById(Long id);

    /**
     * description 查询司机详情-通过帐号
     * param [account]
     * return com.esv.freight.customer.module.driver.dto.DriverDetailDto
     * author Administrator
     * createTime 2020/04/30 11:30
     **/
    DriverDetailDto getDriverDetailByAccount(String account);
    
    /**
     * description 审核司机信息
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/29 9:29
     **/
    Integer auditDriver(DriverAuditForm form);

    /**
     * description 停用司机帐号
     * param [id]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/29 10:03
     **/
    Integer blockDriver(Long id);

    /**
     * description 启用司机帐号
     * param [id]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/29 10:08
     **/
    Integer unblockDriver(Long id);

    /**
     * description 注册司机
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/29 10:43
     **/
    Long registerDriver(DriverInfoForm form);
    
    /**
     * description 查看帐号的审核历史
     * param [id]
     * return java.util.List<com.esv.freight.customer.module.driver.entity.DriverAuditHistoryEntity>
     * author Administrator
     * createTime 2020/04/29 11:21
     **/
    List<DriverAuditHistoryEntity> getAuditHistory(Long id);

    /**
     * description 分页查询司机列表
     * param [queryObj]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/04/29 14:09
     **/
    PageResultVO getDriver4Page(DriverQueryForm queryObj);

    /**
     * description 重置司机帐号密码
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/05/16 16:45
     **/
    Integer resetDriverPwd(DriverInfoForm form);

}

