package com.esv.freight.customer.module.contract.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.util.Date;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.dto.ContractOfflineGoodsOwnerDto
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/19 14:16
 * @version:1.0
 */
@Data
public class ContractOfflineGoodsOwnerDto {

    /**
     *
     */
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 部门ID
     */
    private Long departmentId;
    /**
     * 货主帐号ID
     */
    private Long goodsOwnerId;
    /**
     * 合同编号
     */
    private String contractNumber;
    /**
     * 合同名称
     */
    private String contractName;
    /**
     * 合同类型：1-主合同、2-补充合同、3-临时合同
     */
    private Integer contractType;
    /**
     * 合同签订日期
     */
    private Date signDate;
    /**
     * 合同起始日期
     */
    private Date startDate;
    /**
     * 合同截止日期
     */
    private Date endDate;
    /**
     * 合同文件URL
     */
    private String fileUrl;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 修改者
     */
    private String updateUser;
    /**
     * 创建时间
     */
    private Long createTime;
    /**
     * 修改时间
     */
    private Long updateTime;

    /**
     * 货主类型：1-个人、2-企业
     */
    private Integer ownerType;
    /**
     * 客户名称
     */
    private String ownerFullName;
    /**
     * （个人或企业）联系人
     */
    private String contactor;
}
