package com.esv.freight.customer.common.component;

import com.esv.freight.customer.BaseTestController;
import lombok.extern.slf4j.Slf4j;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.component.RedisComponentTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/16 13:35
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class RedisComponentTest extends BaseTestController {

    @Autowired
    RedisComponent redisComponent;

    @Test
    public void test() {
        String cacheKey = "freight-app-service::token::1::13606060606";
        log.info(redisComponent.get(cacheKey).toString());
        redisComponent.del(cacheKey);
        log.info((String) redisComponent.get(cacheKey));
    }
}
