package com.esv.freight.customer;

import com.esv.freight.customer.common.constants.CommonConstants;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

/**
 * @description:
 * @project: freight-file-service
 * @name: com.esv.freight.customer.BaseController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 14:09
 * @version:1.0
 */
@Slf4j
@Data
public class BaseTestController {

    @Autowired
    WebApplicationContext webApplicationContext;

    MockMvc mockMvc;

    @Before
    public void before() {
        log.info("=================================== Test Start ===================================");
        mockMvc = MockMvcBuilders.webAppContextSetup(webApplicationContext).build();
    }

    @After
    public void after() {
        log.info("=================================== Test End ===================================");
    }

    public HttpHeaders getDefaultHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("gateway_traceid", String.valueOf(System.currentTimeMillis()));
        httpHeaders.add("esv_system", "cc");
        httpHeaders.add("esv_data_perm", "1");
        httpHeaders.add("esv_tenant", "1");
        httpHeaders.add("esv_department", "1");
        httpHeaders.add("esv_department_children", "1,2,3");
        httpHeaders.add("esv_user", "1");
        httpHeaders.add("esv_account", "admin");
        httpHeaders.add("Source-Type", "1");
        httpHeaders.add(CommonConstants.REQ_SOURCE_TYPE_KEY, CommonConstants.REQ_SOURCE_TYPE_WEB);
        return httpHeaders;
    }

}
