package com.esv.freight.customer.module.vehicle.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.vehicle.form.VehicleInfoForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.vehicle.controller.VehicleControllerAddTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/26 15:27
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class VehicleControllerAddTest extends BaseTestController {

    /**
     * 新增车辆：不需要道路运输证号
     **/
    @Test
    public void a1_add_vehicle_no_roadCertificateNumber_success_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12303");
        form.setLicenseType(2); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(14); // 车辆类型(字典表)：14-微型货车
        form.setVehicleType2(1402); // 二级车辆类型(字典表)：1402-微型厢式货车
        form.setLicenseColor(1); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(4800);
        form.setVehicleWidth(1900);
        form.setVehicleHeight(2100);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210101123458");
        form.setLoadCapacity(new BigDecimal("4.0"));
        form.setTotalMass(new BigDecimal("5.1"));
        form.setVehicleOwner("庞俊辉");
        form.setVehicleOwnerCode("210102198005121234");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505511");
        form.setBrandModel("京杯");
        form.setEngineNumber("S12345678");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210103");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_001.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_001.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_001.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_001.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_001.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_001.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增车辆：需要道路运输证号
     **/
    @Test
    public void a2_add_vehicle_need_roadCertificateNumber_success_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12302");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210101123457");
        form.setLoadCapacity(new BigDecimal("14.0"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505512");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345678");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增车辆：需要道路运输证号
     **/
    @Test
    @Rollback
    public void a3_add_vehicle_need_roadCertificateNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12303");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210101123458");
        form.setLoadCapacity(new BigDecimal("14.0"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505518");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345679");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
//        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

    /**
     * 新增车辆：无效的承运商ID
     **/
    @Test
    @Rollback
    public void a4_add_vehicle_wrong_carrierId_failure_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(99999L);
        form.setLicenseNumber("辽A12303");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210101123458");
        form.setLoadCapacity(new BigDecimal("14.0"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505518");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345679");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增车辆：车牌号已存在
     **/
    @Test
    @Rollback
    public void a5_add_vehicle_wrong_licenseNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12301");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210101123458");
        form.setLoadCapacity(new BigDecimal("14.0"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505518");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345679");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 新增车辆：行驶证档案编号已存在
     **/
    @Test
    @Rollback
    public void a6_add_vehicle_wrong_licenseNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12309");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("210101123456");
        form.setLoadCapacity(new BigDecimal("14.0"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505518");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345679");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 新增车辆：道路运输证号已存在
     **/
    @Test
    @Rollback
    public void a7_add_vehicle_wrong_roadCertificateNumber_failure_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12309");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("230101123456");
        form.setLoadCapacity(new BigDecimal("14.0"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505518");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345679");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 新增车辆：核定载质量(吨)不合法
     **/
    @Test
    @Rollback
    public void a8_add_vehicle_wrong_loadCapacity_failure_test() throws Exception {
        String url = "/carrier/vehicle/add";

        // 构造数据
        VehicleInfoForm form = new VehicleInfoForm();
        form.setCarrierId(2L);
        form.setLicenseNumber("辽A12309");
        form.setLicenseType(1); // 牌照类型(字典表)：1-大型汽车号牌、2-小型汽车号牌、3-其他号牌
        form.setVehicleType(12); // 车辆类型(字典表)：12-中型货车
        form.setVehicleType2(1201); // 二级车辆类型(字典表)：1201-中型普通货车
        form.setLicenseColor(2); // 车牌颜色(字典表)：1-蓝色、2-黄色、3-黑色、4-白色、5-绿色、6-农黄色、7-农绿色、8-黄绿色、9-渐变绿、0-其他
        form.setVehicleLength(5800);
        form.setVehicleWidth(2100);
        form.setVehicleHeight(2500);
        form.setVehicleBelong(1); // 车辆所属(字典表)：1-自有车、2-外协车
        form.setYearAuditDate("20191018");
        form.setEnergyType(2); // 能源类型(字典表)：1-汽油、2-柴油、3-电、4-混合油、5-天然气、6-液化石油气、7-甲醇、8-乙醇、9-太阳能、10-混合动力、0-其他
        form.setVehicleLicenseNumber("230101123456");
        form.setLoadCapacity(new BigDecimal("0.5"));
        form.setTotalMass(new BigDecimal("18.1"));
        form.setVehicleOwner("辽宁省沈阳市恒源物流有限公司");
        form.setVehicleOwnerCode("91310107MA1G11CY6D");
        form.setUseNature("营运");
        form.setRegisterDate("20150618");
        form.setVin("LGWEF6A59HH505518");
        form.setBrandModel("重汽豪沃HOWO-7自卸车");
        form.setEngineNumber("H12345679");
        form.setVehicleLicenseIssuedDate("20160618");
        form.setVehicleLicenseIssueDepartment("辽宁省沈阳市公安局交通警察支队");
        form.setRoadCertificateNumber("510184010714");
        form.setVehicleProvinceCode("210000");
        form.setVehicleCityCode("210100");
        form.setVehicleDistrictCode("210105");
        form.setEtc(1); // 是否开通ETC：1-已开通、2-未开通、3-未知
        form.setVehicleHeadUrl("http://127.0.0.1/Vehicle_Head_Url_011.jpg");
        form.setVehicleHeadPersonUrl("http://127.0.0.1/Vehicle_Head_Person_Url_011.jpg");
        form.setVehicleLicenseFrontUrl("http://127.0.0.1/Vehicle_License_Front_Url_011.jpg");
        form.setVehicleLicenseBackUrl("http://127.0.0.1/Vehicle_License_Back_Url_011.jpg");
        form.setRoadCertificateFrontUrl("http://127.0.0.1/Road_Certificate_Front_Url_011.jpg");
        form.setAttachedStatementUrl("http://127.0.0.1/Attached_Statement_Url_011.jpg");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }
}
