package com.esv.freight.customer.module.driver.service;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.driver.form.DriverQueryForm;
import com.esv.freight.customer.module.driver.form.DriverVehicleForm;
import com.esv.freight.customer.module.driver.vo.CarrierDriverVehicleVO;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.driver.vo.VehicleCanBindDriverVO;
import com.esv.freight.customer.module.driver.vo.VehicleDriverListVO;
import com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity;

import java.util.List;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.service.DriverVehicleService
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 16:51
 * @version:1.0
 */
public interface DriverVehicleService {

    /**
     * description 获取司机绑定的车辆列表
     * param [id]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.DriverVehicleListVO>
     * author Administrator
     * createTime 2020/04/29 16:55
     **/
    List<DriverVehicleListVO> getDriverBindVehicleList(Long id);
    
    /**
     * description 获取车辆绑定的司机列表
     * param [id]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.VehicleDriverListVO>
     * author Administrator
     * createTime 2020/05/07 16:21
     **/
    List<VehicleDriverListVO> getVehicleBindDriverList(Long id);

    /**
     * description 绑定司机与车辆
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/29 19:57
     **/
    Integer driverBindVehicle(DriverVehicleForm form);

    /**
     * description 解绑司机与车辆
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/30 9:38
     **/
    Integer driverUnbindVehicle(DriverVehicleForm form);

    /**
     * description 通过司机ID/车辆ID获取绑定记录
     * param [form]
     * return com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity
     * author Administrator
     * createTime 2020/04/30 15:56
     **/
    VehicleDriverEntity getRecordBy2Id(DriverVehicleForm form);
    
    /**
     * description 验证司机与车辆是否绑定
     * param [form]
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/04/30 15:59
     **/
    JSONObject checkBind(DriverVehicleForm form);

    /**
     * description 查询指定承运商的司机与车辆绑定列表
     * param [carrierId]
     * return java.util.List<com.esv.freight.customer.module.driver.dto.DriverVehicleDto>
     * author Administrator
     * createTime 2020/05/06 11:14
     **/
    List<CarrierDriverVehicleVO> getDriverVehicle4Carrier(Long carrierId);

    /**
     * description 查询车辆可以绑定的司机列表
     * param [form]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/05/13 10:37
     **/
    PageResultVO selectVehicleCanBindDriverList(DriverQueryForm form);

}
