package com.esv.freight.customer.module.vehicle.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.freight.customer.module.driver.dto.DriverVehicleDto;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.driver.vo.VehicleDriverListVO;
import com.esv.freight.customer.module.vehicle.entity.VehicleDriverEntity;
import com.esv.freight.customer.module.vehicle.form.VehicleQueryForm;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Map;

/**
 * 车辆司机表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 13:37:33
 */
@Mapper
public interface VehicleDriverDao extends BaseMapper<VehicleDriverEntity> {

    /**
     * description 查询司机绑定的车辆列表
     * param [driverId]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.DriverVehicleListVO>
     * author Administrator
     * createTime 2020/04/29 17:54
     **/
    List<DriverVehicleListVO> selectDriverBindVehicleList(Long driverId);

    /**
     * description 查询车辆绑定的司机列表
     * param [vehicleId]
     * return java.util.List<com.esv.freight.customer.module.driver.vo.VehicleDriverListVO>
     * author Administrator
     * createTime 2020/05/07 16:15
     **/
    List<VehicleDriverListVO> selectVehicleBindDriverList(Long vehicleId);

    /**
     * description 查询指定承运商的司机与车辆绑定列表
     * param [carrierId]
     * return java.util.List<com.esv.freight.customer.module.driver.dto.DriverVehicleDto>
     * author Administrator
     * createTime 2020/05/06 11:08
     **/
    List<DriverVehicleDto> selectDriverVehicle4Carrier(Long carrierId);

    /**
     * description 查询车辆可以绑定的司机列表
     * param [page, queryObj]
     * return com.baomidou.mybatisplus.core.metadata.IPage
     * author Administrator
     * createTime 2020/05/13 10:32
     **/
    IPage selectVehicleCanBindDriverList(IPage page, Map<String, Object> queryObj);
	
}
