package com.esv.freight.customer.module.goodsowner.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.goodsowner.form.AccountAndAddressForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.AccountAndAddressControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 10:49
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class AccountAndAddressControllerTest extends BaseTestController {

    /**
     * 获取货主和地址信息
     **/
    @Test
    public void a1_getOwnerAndAddressInfo_success_test() throws Exception {
        String url = "/goodsowner//ext/getOwnerAndAddressInfo";

        // 构造数据
        AccountAndAddressForm form = new AccountAndAddressForm();
        form.setOwnerId(1L);
        form.setDeliveryAddressId(7L);
        form.setReceiveAddressId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("ownerInfo"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("deliveryAddressInfo"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("receiveAddressInfo"));
    }

    /**
     * 获取货主和地址信息：无效的货主ID
     **/
    @Test
    public void a1_getOwnerAndAddressInfo_wrong_owner_id_failure_test() throws Exception {
        String url = "/goodsowner//ext/getOwnerAndAddressInfo";

        // 构造数据
        AccountAndAddressForm form = new AccountAndAddressForm();
        form.setOwnerId(99999L);
        form.setDeliveryAddressId(7L);
        form.setReceiveAddressId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 获取货主和地址信息：无效的发货地址ID
     **/
    @Test
    public void a2_getOwnerAndAddressInfo_wrong_delivery_id_failure_test() throws Exception {
        String url = "/goodsowner//ext/getOwnerAndAddressInfo";

        // 构造数据
        AccountAndAddressForm form = new AccountAndAddressForm();
        form.setOwnerId(1L);
        form.setDeliveryAddressId(99999L);
        form.setReceiveAddressId(5L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 获取货主和地址信息：无效的收货地址ID
     **/
    @Test
    public void a3_getOwnerAndAddressInfo_wrong_receive_id_failure_test() throws Exception {
        String url = "/goodsowner//ext/getOwnerAndAddressInfo";

        // 构造数据
        AccountAndAddressForm form = new AccountAndAddressForm();
        form.setOwnerId(1L);
        form.setDeliveryAddressId(7L);
        form.setReceiveAddressId(99999L);
        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }
}
