package com.esv.freight.customer.module.goodsowner.controller;

import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.module.goodsowner.form.AccountAndAddressForm;
import com.esv.freight.customer.module.goodsowner.service.AccountAndAddressService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 货主和地址Controller
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.controller.AccountAndAddressController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 10:14
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/goodsowner/ext")
@Validated
public class AccountAndAddressController {

    private AccountAndAddressService accountAndAddressService;

    @Autowired
    public AccountAndAddressController(AccountAndAddressService accountAndAddressService) {
        this.accountAndAddressService = accountAndAddressService;
    }

    /**
     * description 获取货主和地址信息
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/23 10:26
     **/
    @PostMapping("/getOwnerAndAddressInfo")
    public EResponse getOwnerAndAddressInfo(@RequestBody @Validated(ValidatorDetail.class) AccountAndAddressForm form) throws EException {
        return EResponse.ok(accountAndAddressService.getOwnerAndAddressInfo(form));
    }
}
