package com.esv.freight.customer.module.driver.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.common.validator.groups.ValidatorList;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.form.DriverQueryForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/28 20:13
 * @version:1.0
 */
@Data
public class DriverQueryForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorDetail.class})
    private Long id;
    /**
     * 承运商帐号ID
     */
    private Long carrierId;
    /**
     * 帐号状态：1-正常、2-停用
     */
    @Range(min = 1, max = 2, message = "参数accountStatus不合法", groups = {ValidatorList.class})
    private Integer accountStatus;
    /**
     * 创建来源：1-平台创建、2-自行注册
     */
    @Range(min = 1, max = 2, message = "参数accountStatus不合法", groups = {ValidatorList.class})
    private Integer sourceType;
    /**
     * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
     */
    @Range(min = 0, max = 2, message = "参数auditStatus不合法", groups = {ValidatorList.class})
    private Integer auditStatus;
    /**
     * 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
     */
    @Range(min = 0, max = 9, message = "参数drivingLicenseType不合法", groups = {ValidatorList.class})
    private Integer drivingLicenseType;
    /**
     * 登录帐号，司机手机号
     */
    @Length(max = 11, message = "参数account长度不合法", groups = {ValidatorList.class})
    private String account;
    /**
     * keywords
     */
    @Length(max = 20, message = "参数keywords长度不合法", groups = {ValidatorList.class})
    private String keywords;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
