package com.esv.freight.customer.module.carrier.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 承运商分页列表VO
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.carrier.vo.CarrierInfoListVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/24 16:58
 * @version:1.0
 */
@Data
public class CarrierInfoListVO {

    /**
     *
     */
    private Long id;
    /**
     * 登录帐号，承运商联系人电话
     */
    private String account;
    /**
     * 帐号状态：1-正常、2-停用
     */
    private String accountStatus;
    /**
     * 创建者
     */
    private String createUser;
    /**
     * 创建时间
     */
    private Long createTime;
    /**
     * 客户编码
     */
    private String carrierNumber;
    /**
     * 统一社会信用代码
     */
    private String uniCreditCode;
    /**
     * 承运商名称
     */
    private String carrierName;
    /**
     * 承运商类别：1-企业承运人、2-个体承运人
     */
    private Integer carrierType;
    /**
     * 承运商车辆类型（字典表）：1-自营车、2-外协车、3-其他
     */
    private Integer carrierVehicleType;
    /**
     * 企业法人姓名
     */
    private String legalPerson;
    /**
     * 道路运输经营许可证号
     */
    private String roadLicenseNumber;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
