package com.esv.freight.customer.module.goodsowner.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 货主常跑线路表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
@TableName("goods_owner_regularly_route")
public class RegularlyRouteEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 货主ID
	 */
	private Long ownerId;
	/**
	 * 线路编码
	 */
	private String routeNumber;
	/**
	 * 线路名称
	 */
	private String routeName;
	/**
	 * 发货地址ID
	 */
	private Long deliveryId;
	/**
	 * 收货地址ID
	 */
	private Long receiveId;
	/**
	 * 0-未删除，1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
