package com.esv.freight.customer.module.driver.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.esv.freight.customer.common.component.ErrorMessageComponent;
import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.module.driver.entity.DriverAccountEntity;
import com.esv.freight.customer.module.driver.service.DriverAccountService;
import com.esv.freight.customer.module.driver.service.DriverVehicleService;
import com.esv.freight.customer.module.driver.vo.DriverVehicleListVO;
import com.esv.freight.customer.module.vehicle.service.VehicleDriverService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.service.impl.DriverVehicleServiceImpl
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 16:55
 * @version:1.0
 */
@Service("driverVehicleService")
public class DriverVehicleServiceImpl implements DriverVehicleService {

    private ErrorMessageComponent errorMessageComponent;

    private DriverAccountService driverAccountService;

    private VehicleDriverService vehicleDriverService;

    public DriverVehicleServiceImpl(ErrorMessageComponent errorMessageComponent, DriverAccountService driverAccountService,
                                    VehicleDriverService vehicleDriverService) {
        this.errorMessageComponent = errorMessageComponent;
        this.driverAccountService = driverAccountService;
        this.vehicleDriverService = vehicleDriverService;
    }

    @Override
    public List<DriverVehicleListVO> getDriverBindVehicleList(Long id) {
        // 1:校验是否有效司机ID
        int count = this.driverAccountService.getBaseMapper().selectCount(new QueryWrapper<DriverAccountEntity>().lambda()
                .eq(DriverAccountEntity::getId, id));
        if (0 == count) {
            throw new EException(1001, errorMessageComponent.getCarrierDriverVehicleList1001());
        }

        // 2:查询司机绑定的车辆列表
        List<DriverVehicleListVO> voList = this.vehicleDriverService.getDriverBindVehicleList(id);
        if (0 == voList.size()) {
            throw new EException(1002, errorMessageComponent.getCarrierDriverVehicleList1002());
        }

        return voList;
    }
}
