package com.esv.freight.customer.module.driver.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.driver.form.DriverQueryForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.controller.DriverVehicleControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 19:17
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class DriverVehicleControllerTest extends BaseTestController {

    /**
     * 查询司机绑定的车辆列表
     **/
    @Test
    public void a1_list_success_test() throws Exception {
        String url = "/carrier/driver/vehicle/list";

        // 构造数据
        DriverQueryForm form = new DriverQueryForm();
        form.setId(1L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(null != result.getJSONArray("data"));
    }

    /**
     * 查询司机绑定的车辆列表：无效的司机ID
     **/
    @Test
    public void a2_list_wrong_id_failure_test() throws Exception {
        String url = "/carrier/driver/vehicle/list";

        // 构造数据
        DriverQueryForm form = new DriverQueryForm();
        form.setId(99999L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 查询司机绑定的车辆列表：该司机未绑定车辆
     **/
    @Test
    public void a3_list_not_bind_vehicle_failure_test() throws Exception {
        String url = "/carrier/driver/vehicle/list";

        // 构造数据
        DriverQueryForm form = new DriverQueryForm();
        form.setId(2L);

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }
}
