package com.esv.freight.customer.module.goodsowner.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 常跑路线详情VO
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Data
public class RouteDetailVO implements Serializable {

	private static final long serialVersionUID = -6456734699222085498L;

	private Long id;

	/**
	 * 线路编码
	 */
	private String routeNumber;
	/**
	 * 线路名称
	 */
	private String routeName;
	/**
	 * 货主ID
	 */
	private Long ownerId;
	/**
	 * 货主名称
	 */
	private String ownerName;
	/**
	 * 发货地址ID
	 */
	private Long deliveryAddressId;
	/**
	 * 发货地址名称
	 */
	private String deliveryAddressName;
	/**
	 * 收货地址ID
	 */
	private Long receiveAddressId;
	/**
	 * 收货地址名称
	 */
	private String receiveAddressName;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
