package com.esv.freight.customer.module.vehicle.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 车辆司机表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 13:37:33
 */
@Data
@TableName("vehicle_driver")
public class VehicleDriverEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 承运商ID
	 */
	private Long carrierId;
	/**
	 * 车辆ID
	 */
	private Long vehicleId;
	/**
	 * 司机ID
	 */
	private Long driverId;
	/**
	 * 是否默认车辆：0-不是、1-是
	 */
	private Boolean selected;
	/**
	 * 操作者
	 */
	private String operateUser;
	/**
	 * 操作时间
	 */
	private Date operateTime;

}
