package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.module.goodsowner.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.AccountForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class AccountForm {

    @NotNull(message = "参数id不能为空", groups = {ValidatorBlock.class, ValidatorUnblock.class, ValidatorAudit.class, ValidatorAuditHistory.class})
    private Long id;

    @NotNull(message = "参数auditStatus不能为空", groups = {ValidatorAudit.class})
    private Integer auditStatus;

    @Length(max = 100, message = "参数remark长度不合法", groups = {ValidatorAudit.class})
    private String remark;

    @Length(min = 11, max = 11, message = "参数account长度不合法", groups = {ValidatorDetail.class, ValidatorPassword.class, ValidatorRegister.class})
    @NotBlank(message = "参数account不能为空", groups = {ValidatorRegister.class})
    private String account;

    @Length(min = 32, max = 32, message = "参数password长度不合法", groups = {ValidatorPassword.class})
    private String password;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
