package com.esv.freight.customer.module.carrier.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.customer.common.vo.PageResultVO;
import com.esv.freight.customer.module.carrier.dto.CarrierInfoDto;
import com.esv.freight.customer.module.carrier.entity.CarrierAccountEntity;
import com.esv.freight.customer.module.carrier.form.CarrierInfoForm;
import com.esv.freight.customer.module.carrier.form.CarrierQueryForm;
import com.esv.freight.customer.module.goodsowner.form.AccountQueryForm;

import java.util.List;

/**
 * 承运商帐号表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-23 16:51:54
 */
public interface CarrierAccountService extends IService<CarrierAccountEntity> {

    /**
     * description 判断帐号是否存在
     * param [form]
     * return boolean
     * author Administrator
     * createTime 2020/04/23 19:38
     **/
    boolean isAccountExit(CarrierQueryForm form);

    /**
     * description 新增承运商
     * param [form]
     * return java.lang.Long
     * author Administrator
     * createTime 2020/04/23 20:02
     **/
    Long insertCarrier(CarrierInfoForm form);

    /**
     * description 编辑承运商信息
     * param [form]
     * return java.lang.Integer
     * author Administrator
     * createTime 2020/04/24 14:27
     **/
    Integer updateCarrier(CarrierInfoForm form);

    /**
     * description 查询承运商详情
     * param [form]
     * return com.esv.freight.customer.module.carrier.dto.CarrierInfoDto
     * author Administrator
     * createTime 2020/04/24 17:06
     **/
    CarrierInfoDto getCarrierDetail(CarrierQueryForm form);

    /**
     * description 查询所有帐号简要信息
     * param []
     * return java.util.List<com.esv.freight.customer.module.carrier.dto.CarrierInfoDto>
     * author Administrator
     * createTime 2020/04/24 17:37
     **/
    List<CarrierInfoDto> getAllCarrierBrief();

    /**
     * description 分页查询帐号列表
     * param [queryObj]
     * return com.esv.freight.customer.common.vo.PageResultVO
     * author Administrator
     * createTime 2020/04/26 9:29
     **/
    PageResultVO getCarrier4Page(CarrierQueryForm queryObj);

    /**
     * description 通过ID查询承运商帐号
     * param [id]
     * return com.esv.freight.customer.module.carrier.entity.CarrierAccountEntity
     * author Administrator
     * createTime 2020/04/29 10:52
     **/
    CarrierAccountEntity getCarrierById(Long id);

}

