package com.esv.freight.customer.module.driver.controller;

import com.esv.freight.customer.common.exception.EException;
import com.esv.freight.customer.common.response.EResponse;
import com.esv.freight.customer.common.validator.groups.ValidatorDetail;
import com.esv.freight.customer.module.driver.form.DriverQueryForm;
import com.esv.freight.customer.module.driver.form.DriverVehicleForm;
import com.esv.freight.customer.module.driver.service.DriverVehicleService;
import com.esv.freight.customer.module.driver.validator.groups.ValidatorBind;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.controller.DriverVehicleController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/29 19:14
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/carrier/driver/vehicle")
@Validated
public class DriverVehicleController {
    
    private DriverVehicleService driverVehicleService;

    @Autowired
    public DriverVehicleController(DriverVehicleService driverVehicleService) {
        this.driverVehicleService = driverVehicleService;
    }

    /**
     * description 查询司机绑定的车辆列表
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/29 19:16
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody @Validated(ValidatorDetail.class) DriverQueryForm form) throws EException {
        return EResponse.ok(driverVehicleService.getDriverBindVehicleList(form.getId()));
    }

    /**
     * description 司机绑定车辆
     * param [form]
     * return com.esv.freight.customer.common.response.EResponse
     * author Administrator
     * createTime 2020/04/29 20:16
     **/
    @PostMapping("/bind")
    public EResponse bind(@RequestBody @Validated(ValidatorBind.class) DriverVehicleForm form) throws EException {
        driverVehicleService.driverBindVehicle(form);
        
        return EResponse.ok();
    }
}
