package com.esv.freight.customer.module.driver.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.driver.DriverConstants;
import com.esv.freight.customer.module.driver.form.DriverInfoForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.driver.controller.DriverAccountAddTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/28 17:26
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class DriverAccountAddTest extends BaseTestController {

    /**
     * 新增司机：不需要道路运输从业资格证
     **/
    @Test
    public void a1_add_vehicle_no_certificate_success_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340001");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上飞");
        form.setIdCard("210102198003076734");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340001.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340001.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003076734");
        form.setDrivingLicenseType(8); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340001.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_1); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增司机：需要道路运输从业资格证
     **/
    @Test
    public void a2_add_vehicle_with_certificate_success_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跑");
        form.setIdCard("210102198003079775");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340002.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340002.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003079775");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340002.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_2); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setCertificateNumber("210102198003079775");
        form.setCertificateEndDate("2025/5/30");
        form.setCertificateUrl("http://127.0.0.1/certificate_url_18512340002.jpg");
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增司机：账号已存在
     **/
    @Test
    @Rollback
    public void a3_add_vehicle_wrong_account_failure_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340002");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跑");
        form.setIdCard("210102198003079775");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340002.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340002.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003079775");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340002.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_2); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setCertificateNumber("210102198003079775");
        form.setCertificateEndDate("2025/5/30");
        form.setCertificateUrl("http://127.0.0.1/certificate_url_18512340002.jpg");
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增司机：身份证号码已存在
     **/
    @Test
    @Rollback
    public void a4_add_vehicle_wrong_IdCard_failure_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340012");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跑");
        form.setIdCard("210102198003079775");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340002.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340002.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003079775");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340002.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_2); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setCertificateNumber("210102198003079775");
        form.setCertificateEndDate("2025/5/30");
        form.setCertificateUrl("http://127.0.0.1/certificate_url_18512340002.jpg");
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 新增司机：驾驶证号码已存在
     **/
    @Test
    @Rollback
    public void a5_add_vehicle_wrong_DrivingLicense_failure_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340012");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跑");
        form.setIdCard("210102198003072477");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340002.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340002.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003079775");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340002.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_2); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setCertificateNumber("210102198003079775");
        form.setCertificateEndDate("2025/5/30");
        form.setCertificateUrl("http://127.0.0.1/certificate_url_18512340002.jpg");
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1003, result.getIntValue("code"));
    }

    /**
     * 新增司机：从业资格证号已存在
     **/
    @Test
    @Rollback
    public void a6_add_vehicle_wrong_DrivingLicense_failure_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340012");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跑");
        form.setIdCard("210102198003072477");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340002.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340002.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003072477");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340002.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_2); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setCertificateNumber("210102198003079775");
        form.setCertificateEndDate("2025/5/30");
        form.setCertificateUrl("http://127.0.0.1/certificate_url_18512340002.jpg");
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1004, result.getIntValue("code"));
    }

    /**
     * 新增司机：无道路运输从业资格证信息
     **/
    @Test
    @Rollback
    public void a7_add_vehicle_no_Certificate_failure_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(2L);
        form.setAccount("18512340012");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跑");
        form.setIdCard("210102198003072477");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340002.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340002.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1980/3/7");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210102");
        form.setDetailAddress("青年大街1号河畔花园1-1");
        form.setDrivingLicense("210102198003072477");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队和平分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340002.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_2); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.PARAM_ERROR.code(), result.getIntValue("code"));
    }

    /**
     * 新增司机：无效的承运商ID
     **/
    @Test
    @Rollback
    public void a8_add_vehicle_wrong_carrierId_failure_test() throws Exception {
        String url = "/carrier/driver/add";

        // 构造数据
        DriverInfoForm form = new DriverInfoForm();
        form.setCarrierId(99999L);
        form.setAccount("18512340013");
        form.setPassword("e10adc3949ba59abbe56e057f20f883e");
        form.setName("路上跳");
        form.setIdCard("210104198106036252");
        form.setIdCardExpireDate("2030/10/31");
        form.setIdCardFrontUrl("http://127.0.0.1/id_card_front_url_18512340012.jpg");
        form.setIdCardBackUrl("http://127.0.0.1/id_card_back_url_18512340012.jpg");
        form.setSettlementType(1); // 结算对象(字典表)：1-个人、2-所属承运商
        form.setSex(1); // 性别(字典表)：1-男、2-女、3-未知
        form.setBirthDate("1981/6/3");
        form.setNation("满族");
        form.setNativePlace("辽宁沈阳");
        form.setProvinceCode("210000");
        form.setCityCode("210100");
        form.setDistrictCode("210103");
        form.setDetailAddress("青年大街245号河畔花园1-1");
        form.setDrivingLicense("210104198106036252");
        form.setDrivingLicenseType(7); // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
        form.setDrivingLicenseStartDate("2015/8/1");
        form.setDrivingLicenseEndDate("2021/7/30");
        form.setDrivingLicenseIssueDepartment("沈阳市公安局交通警察支队大东分局");
        form.setDrivingLicenseInitDate("2015/8/1");
        form.setDrivingLicenseUrl("http://127.0.0.1/driving_license_url_18512340013.jpg");
        form.setCertificateVehicle(DriverConstants.ACCOUNT_DRIVING_VEHICLE_TYPE_1); // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
        form.setRemark("测试数据");

        JSONObject reqJson = JSONObject.parseObject(form.toString());

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(reqJson.toJSONString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1005, result.getIntValue("code"));
    }
}
