package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorInsert;
import com.esv.freight.customer.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.AccountInfoForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class AccountInfoForm {

    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class})
    private Long id;

    /**
     * （个人或企业联系人手机号）帐号
     */
    @Length(min = 11, max = 11, message = "参数account长度不合法", groups = {ValidatorInsert.class})
    @NotBlank(message = "参数account不能为空", groups = {ValidatorInsert.class})
    private String account;
    /**
     * 帐号密码
     */
    @Length(min = 32, max = 32, message = "参数password长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数password不能为空", groups = {ValidatorInsert.class})
    private String password;
    /**
     * 货主类型：1-个人、2-企业
     */
    @Range(min = 1, max = 2, message = "参数ownerType不合法", groups = {ValidatorInsert.class})
    @NotNull(message = "参数ownerType不能为空", groups = {ValidatorInsert.class})
    private Integer ownerType;
    /**
     * 客户名称
     */
    @Length(max = 50, message = "参数ownerFullName长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String ownerFullName;
    /**
     * 客户简称
     */
    @Length(max = 50, message = "参数ownerBriefName长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String ownerBriefName;
    /**
     * 统一社会信用代码
     */
    @Length(max = 20, message = "参数uniCreditCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String uniCreditCode;
    /**
     * 营业期限
     */
    @Length(max = 50, message = "参数creditExpireDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String creditExpireDate;
    /**
     * 营业执照正本ULR
     */
    @Length(max = 200, message = "参数creditOriginalUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String creditOriginalUrl;
    /**
     * 营业执照副本ULR
     */
    @Length(max = 200, message = "参数creditCopyUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String creditCopyUrl;
    /**
     * 企业法人姓名
     */
    @Length(max = 20, message = "参数legalPerson长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String legalPerson;
    /**
     * 企业法人手机号
     */
    @Length(max = 20, message = "参数legalPhone长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String legalPhone;
    /**
     * 省份代码
     */
    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数provinceCode不能为空", groups = {ValidatorInsert.class})
    private String provinceCode;
    /**
     * 市代码
     */
    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数cityCode不能为空", groups = {ValidatorInsert.class})
    private String cityCode;
    /**
     * 区县代码
     */
    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数districtCode不能为空", groups = {ValidatorInsert.class})
    private String districtCode;
    /**
     * 详细地址
     */
    @Length(max = 100, message = "参数detailAddress长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数detailAddress不能为空", groups = {ValidatorInsert.class})
    private String detailAddress;
    /**
     * （个人或企业）联系人
     */
    @Length(max = 20, message = "参数contactor长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数contactor不能为空", groups = {ValidatorInsert.class})
    private String contactor;
    /**
     * （个人或企业）身份证号码
     */
    @Length(min = 18, max = 18, message = "参数idCard长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCard不能为空", groups = {ValidatorInsert.class})
    private String idCard;
    /**
     * （个人或企业）身份证有效期
     */
    @Length(max = 50, message = "参数idCardExpireDate长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String idCardExpireDate;
    /**
     * 身份证正面图片URL
     */
    @Length(max = 200, message = "参数idCardFrontUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCardFrontUrl不能为空", groups = {ValidatorInsert.class})
    private String idCardFrontUrl;
    /**
     * 身份证背面图片URL
     */
    @Length(max = 200, message = "参数idCardBackUrl长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotBlank(message = "参数idCardBackUrl不能为空", groups = {ValidatorInsert.class})
    private String idCardBackUrl;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
