package com.esv.freight.customer.module.driver.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 司机帐号表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-28 14:47:01
 */
@Data
@TableName("driver_account")
public class DriverAccountEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 租户ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long tenantId;
	/**
	 * 部门ID
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long departmentId;
	/**
	 * 承运商帐号ID
	 */
	private Long carrierId;
	/**
	 * 登录帐号，司机手机号
	 */
	private String account;
	/**
	 * 密码
	 */
	private String password;
	/**
	 * 密码盐
	 */
	private String salt;
	/**
	 * 帐号状态：1-正常、2-停用
	 */
	private Integer accountStatus;
	/**
	 * 创建来源：1-平台创建、2-自行注册
	 */
	private Integer sourceType;
	/**
	 * 审核状态(字典表)：0-待审核、1-审核成功，2-审核失败
	 */
	private Integer auditStatus;
	/**
	 * 上报状态(字典表)：0-未上报、1-上报成功、2-上报失败
	 */
	private Integer reportStatus;
	/**
	 * 上报时间
	 */
	private Date reportTime;
	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 修改者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 修改时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

}
