package com.esv.freight.customer.module.goodsowner.form;

import com.esv.freight.customer.common.validator.groups.ValidatorList;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.goodsowner.form.RegularlyRouteListForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/17 16:11
 * @version:1.0
 */
@Data
public class RegularlyRouteListForm {

    @Length(max = 50, message = "参数ownerName长度不合法", groups = {ValidatorList.class})
    private String ownerName;

    @Length(max = 50, message = "参数deliveryAddressName长度不合法", groups = {ValidatorList.class})
    private String deliveryAddressName;

    @Length(max = 50, message = "参数receiveAddressName长度不合法", groups = {ValidatorList.class})
    private String receiveAddressName;

    /**
     * 页码
     **/
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;
    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
