package com.esv.freight.customer.common.pojo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 银联APP终端创建支付订单返回参数
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.common.pojo.AppUnionPayOrder
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/30 13:48
 * @version:1.0
 */
@Data
public class AppUnionPayOrderRes {
    /**
     * 银联受理订单号
     */
    private String tn;
    /**
     * 请求参数
     */
    private String reqMessage;
    /**
     * 返回参数
     */
    private String rspMessage;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
