package com.esv.freight.customer.module.contract.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.vo.ContractOnlineRecordListVO
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/22 16:37
 * @version:1.0
 */
@Data
public class ContractOnlineRecordListVO {

    /**
     *
     */
    private Long id;
    /**
     * 合同类型：1-货主与平台合同、2-司机与平台合同
     */
    private Integer contractType;
    /**
     * 合同文件ID
     */
    private String contractFileId;
    /**
     * 合同文件URL
     */
    private String contractFileUrl;
    /**
     * 合同编号
     */
    private String contractNumber;
    /**
     * 业务编号（订单号或运单号）
     */
    private String businessNumber;
    /**
     * 客户ID
     */
    private Long customerId;
    /**
     * 合同签订完成：1-是，2-否
     */
    private Integer signComplete;
    /**
     * 合同生效时间
     */
    private Long effectiveTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
