package com.esv.freight.customer.module.pay.form;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.pay.form.UnionPayOrderQueryForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/03 13:29
 * @version:1.0
 */
@Data
public class UnionPayOrderQueryForm {

    /**
     * 订单流水号
     */
    @Length(max = 50, message = "参数tn长度不合法")
    private String tn;

    /**
     * 订单号
     */
    @Length(max = 50, message = "参数billId长度不合法")
    private String billId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
