package com.esv.freight.customer.module.pay.form;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.pay.form.CustomerPayOrderForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/06/01 17:15
 * @version:1.0
 */
@Data
public class CustomerPayOrderForm {
    /**
     * 客户ID
     */
    @NotNull(message = "参数customerId不能为空")
    private Long customerId;
    /**
     * 账单号
     */
    @NotBlank(message = "参数billId不能为空")
    @Length(min = 8, max = 40, message = "参数billId长度不合法")
    private String billId;
    /**
     * 账单描述
     */
    @NotBlank(message = "参数billDesc不能为空")
    @Length(max = 32, message = "参数billDesc长度不合法")
    private String billDesc;
    /**
     * 交易金额(单位为分)
     */
    @NotNull(message = "参数txnAmt不能为空")
    private Long txnAmt;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
