package com.esv.freight.customer.module.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.customer.BaseTestController;
import com.esv.freight.customer.common.response.ECode;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerForm;
import com.esv.freight.customer.module.contract.form.ContractOfflineGoodsOwnerQueryForm;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description:
 * @project: freight-customer-service
 * @name: com.esv.freight.customer.module.contract.controller.ContractOfflineGoodsOwnerControllerTest
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/19 16:11
 * @version:1.0
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
@Transactional
@Rollback(false)
public class ContractOfflineGoodsOwnerControllerTest extends BaseTestController {

    /**
     * 新增合同
     **/
    @Test
    public void a1_add_success_test() throws Exception {
        String url = "/contract/offline/goodsowner/add";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setGoodsOwnerId(4L);
        form.setContractNumber("202005191001");
        form.setContractName("黄朝斌测试有限公司01-运输业务框架合同");
        form.setContractType(1); // 合同类型：1-主合同、2-补充合同、3-临时合同
        form.setSignDate("2020-05-19");
        form.setStartDate("2020-05-20");
        form.setEndDate("2021-05-19");
        form.setFileUrl("http://192.168.31.248:8082/file/download/direct/6FB1DC2B9961B3AFFDE452A479766F6C2E5B46D3534376A8C40ACB4987D0602B85D1E1739AF93D52A92AEB7ACABB90DC");
        form.setRemark("这是一条测试数据");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("id"));
    }

    /**
     * 新增合同：无效的货主ID
     **/
    @Test
    public void a2_add_wrong_goodsOwnerId_failure_test() throws Exception {
        String url = "/contract/offline/goodsowner/add";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setGoodsOwnerId(99999L);
        form.setContractNumber("202005191001");
        form.setContractName("黄朝斌测试有限公司01-运输业务框架合同");
        form.setContractType(1); // 合同类型：1-主合同、2-补充合同、3-临时合同
        form.setSignDate("2020-05-19");
        form.setStartDate("2020-05-20");
        form.setEndDate("2021-05-19");
        form.setFileUrl("http://192.168.31.248:8082/file/download/direct/6FB1DC2B9961B3AFFDE452A479766F6C2E5B46D3534376A8C40ACB4987D0602B85D1E1739AF93D52A92AEB7ACABB90DC");
        form.setRemark("这是一条测试数据");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 新增合同：合同编号已存在
     **/
    @Test
    public void a3_add_wrong_contractNumber_failure_test() throws Exception {
        String url = "/contract/offline/goodsowner/add";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setGoodsOwnerId(4L);
        form.setContractNumber("202005191001");
        form.setContractName("黄朝斌测试有限公司01-运输业务框架合同");
        form.setContractType(1); // 合同类型：1-主合同、2-补充合同、3-临时合同
        form.setSignDate("2020-05-19");
        form.setStartDate("2020-05-20");
        form.setEndDate("2021-05-19");
        form.setFileUrl("http://192.168.31.248:8082/file/download/direct/6FB1DC2B9961B3AFFDE452A479766F6C2E5B46D3534376A8C40ACB4987D0602B85D1E1739AF93D52A92AEB7ACABB90DC");
        form.setRemark("这是一条测试数据");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 编辑合同
     **/
    @Test
    @Rollback
    public void b1_edit_success_test() throws Exception {
        String url = "/contract/offline/goodsowner/edit";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setId(1L);
        form.setContractNumber("202005191001");
        form.setContractName("黄朝斌测试有限公司01-运输业务框架合同");
        form.setContractType(1); // 合同类型：1-主合同、2-补充合同、3-临时合同
        form.setSignDate("2020-05-19");
        form.setStartDate("2020-05-20");
        form.setEndDate("2021-05-19");
        form.setFileUrl("http://192.168.31.248:8082/file/download/direct/6FB1DC2B9961B3AFFDE452A479766F6C2E5B46D3534376A8C40ACB4987D0602B85D1E1739AF93D52A92AEB7ACABB90DC");
        form.setRemark("这是一条测试数据");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 编辑合同：无效的合同ID
     **/
    @Test
    @Rollback
    public void b2_edit_wrong_id_failure_test() throws Exception {
        String url = "/contract/offline/goodsowner/edit";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setId(99999L);
        form.setContractNumber("202005191001");
        form.setContractName("黄朝斌测试有限公司01-运输业务框架合同");
        form.setContractType(1); // 合同类型：1-主合同、2-补充合同、3-临时合同
        form.setSignDate("2020-05-19");
        form.setStartDate("2020-05-20");
        form.setEndDate("2021-05-19");
        form.setFileUrl("http://192.168.31.248:8082/file/download/direct/6FB1DC2B9961B3AFFDE452A479766F6C2E5B46D3534376A8C40ACB4987D0602B85D1E1739AF93D52A92AEB7ACABB90DC");
        form.setRemark("这是一条测试数据");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 编辑合同：合同编号已存在
     **/
    @Test
    @Rollback
    public void b3_edit_wrong_contractNumber_failure_test() throws Exception {
        String url = "/contract/offline/goodsowner/edit";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setId(1L);
        form.setContractNumber("202005191002");
        form.setContractName("黄朝斌测试有限公司01-运输业务框架合同");
        form.setContractType(1); // 合同类型：1-主合同、2-补充合同、3-临时合同
        form.setSignDate("2020-05-19");
        form.setStartDate("2020-05-20");
        form.setEndDate("2021-05-19");
        form.setFileUrl("http://192.168.31.248:8082/file/download/direct/6FB1DC2B9961B3AFFDE452A479766F6C2E5B46D3534376A8C40ACB4987D0602B85D1E1739AF93D52A92AEB7ACABB90DC");
        form.setRemark("这是一条测试数据");

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1002, result.getIntValue("code"));
    }

    /**
     * 删除合同
     **/
    @Test
    @Rollback
    public void c1_delete_success_test() throws Exception {
        String url = "/contract/offline/goodsowner/delete";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setId(1L);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
    }

    /**
     * 删除合同：无效的合同ID
     **/
    @Test
    @Rollback
    public void c2_delete_success_test() throws Exception {
        String url = "/contract/offline/goodsowner/delete";

        // 构造数据
        ContractOfflineGoodsOwnerForm form = new ContractOfflineGoodsOwnerForm();
        form.setId(99999L);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(1001, result.getIntValue("code"));
    }

    /**
     * 货主合同-分页查询
     **/
    @Test
    @Rollback
    public void d1_list_success_test() throws Exception {
        String url = "/contract/offline/goodsowner/list";

        // 构造数据
        ContractOfflineGoodsOwnerQueryForm form = new ContractOfflineGoodsOwnerQueryForm();
        form.setPageNum(1);
        form.setPageSize(10);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("totalSize"));
    }

    /**
     * 货主合同-分页查询
     **/
    @Test
    @Rollback
    public void d2_list_with_params_success_test() throws Exception {
        String url = "/contract/offline/goodsowner/list";

        // 构造数据
        ContractOfflineGoodsOwnerQueryForm form = new ContractOfflineGoodsOwnerQueryForm();
        form.setKeywords("2020");
        form.setPageNum(1);
        form.setPageSize(10);

        MvcResult mvcResult = this.getMockMvc().perform(MockMvcRequestBuilders.post(url)
                .contentType(MediaType.APPLICATION_JSON_UTF8_VALUE)
                .headers(this.getDefaultHttpHeaders())
                .content(form.toString()))
                .andDo(MockMvcResultHandlers.print())
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andReturn();

        String responseStr = mvcResult.getResponse().getContentAsString();
        log.info(responseStr);

        JSONObject result = JSONObject.parseObject(responseStr);
        Assert.assertEquals(ECode.SUCCESS.code(), result.getIntValue("code"));
        Assert.assertTrue(result.getJSONObject("data").containsKey("totalSize"));
    }
}
