package com.esv.freight.customer.module.goodsowner.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto;
import com.esv.freight.customer.module.goodsowner.entity.AccountEntity;
import com.esv.freight.customer.module.goodsowner.form.AccountQueryForm;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 货主基础信息表
 * 
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-17 13:54:57
 */
@Mapper
public interface AccountDao extends BaseMapper<AccountEntity> {

    /**
     * description 通过帐号id获取帐号信息
     * param [id]
     * return com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto
     * author Administrator
     * createTime 2020/04/20 9:41
     **/
    AccountInfoDto getAccountInfoById(Long id);

    /**
     * description 通过帐号获取帐号信息
     * param [account]
     * return com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto
     * author Administrator
     * createTime 2020/04/20 9:41
     **/
    AccountInfoDto getAccountInfoByAccount(String account);

    /**
     * description 分页查询帐号列表
     * param [page, queryObj]
     * return com.baomidou.mybatisplus.core.metadata.IPage
     * author Administrator
     * createTime 2020/04/20 19:51
     **/
    IPage selectAccountInfoList(IPage page, AccountQueryForm queryObj);

    /**
     * description 获取所有可用货主帐号列表
     * param []
     * return java.util.List<com.esv.freight.customer.module.goodsowner.dto.AccountInfoDto>
     * author Administrator
     * createTime 2020/04/21 9:18
     **/
    List<AccountInfoDto> selectAllAvailableAccount();
	
}
